import javax.swing.*;
import java.awt.*;

/** This class demonstrates the placement of buttons in a
    JFrame, using the default layout manager BorderLayout.
    
    It places five buttons, in each of the five possible
    positions.
  */
public class ButtonExample extends JFrame {
    /** Constructor: an invisible frame with title t and 5 buttons */
    public ButtonExample(String t) {
        super(t);
        
        Container cp= getContentPane();
        cp.add(new JButton("south"),  BorderLayout.SOUTH);
        cp.add(new JButton("north"),  BorderLayout.NORTH);
        cp.add(new JButton("east"),   BorderLayout.EAST);
        cp.add(new JButton("west"),   BorderLayout.WEST);
        cp.add(new JButton("center"), BorderLayout.CENTER);
        
        pack();
        
    }
    
    public static void main(String[] args) {
    	ButtonExample be= new ButtonExample("Placing buttons");
    	be.setVisible(true);
    }
}